model Ex20_9 "system of ODEs - euler method"
  
  parameter Real x0 = 0;
  parameter Real xf = 2;
  parameter Real[2] y0 = {4, 6};
  parameter Real h = 0.5 "step size";
  parameter Integer n = integer(ceil((xf-x0)/h));
  Real[2, n+1] y;
  Real[n+1] x;
 equation
  x[1] = x0;
  y[1, 1] = y0[1];
  y[2, 1] = y0[2];
 for i in 1:n loop
  x[i+1] = x[i] + h;
  y[1, i+1] = y[1, i] + h * (-0.5 * y[1, i]);
  y[2, i+1] = y[2, i] + h * (4 - 0.3*y[2, i] - 0.1 * y[1, i]);
  end for;
end Ex20_9;
