model Ex21_1 "explicit and implicit euler"

  function f
    input Real y;
    input Real t;
    output Real dy;
   algorithm
    dy := -1000 * y + 3000 - 2000 * exp(-t);
  end f;
  
  parameter Real h_a1 = 0.0005 "1st step size for part (a)";
  parameter Real h_a2 = 0.0015 "2nd step size for part (a)";
  parameter Real h_b = 0.05 "step size for part (b)";
  parameter Integer n_a1 = integer(ceil(0.006/h_a1)) + 1 "number of points for step size h_a1";
  parameter Integer n_a2 = integer(ceil(0.006/h_a2)) + 1 "number of points for step size h_a2";
  parameter Integer n_b = integer(ceil(0.4/h_b)) + 1 "number of points for step size h_b";
  Real[n_a1] t_a1 "time values for h_a1 in part (a)";
  Real[n_a2] t_a2 "time values for h_a2 in part (a)";
  Real[n_b] t_b "time values for part (b)";
  Real[n_a1] y_a1 "y values for h_a1 in part (a)";
  Real[n_a2] y_a2 "y values for h_a2 in part (a)";
  Real[n_b] y_b "y values for part (b)";
 equation
  t_a1[1] = 0;
  t_a2[1] = 0;
  t_b[1] = 0;
  y_a1[1] = 0;
  y_a2[1] = 0;
  y_b[1] = 0;
  for i in 2:n_a1 loop
    t_a1[i] = t_a1[i-1] + h_a1;
  end for;
  for i in 2:n_a2 loop
    t_a2[i] = t_a2[i-1] + h_a2;
  end for;
  for i in 2:n_b loop
    t_b[i] = t_b[i-1] + h_b;
  end for;
  
  for i in 2:n_a1 loop
    y_a1[i] = y_a1[i-1] + h_a1 * f(y_a1[i-1], t_a1[i-1]);
  end for;
  for i in 2:n_a2 loop
    y_a2[i] = y_a2[i-1] + h_a2 * f(y_a2[i-1], t_a2[i-1]);
  end for;
  for i in 2:n_b loop
    y_b[i] = (y_b[i-1] + 3000 * h_b - 2000 * h_b * exp(-1*t_b[i]))/(1 + 1000 * h_b);
  end for;
  
  

end Ex21_1;
