model Ex24_1 "Temperature of a heated plate with fixed boundary conditions"

  function temp
    input Real l;
    input Real[3,3] t0;
    input Integer n;
    output Real[3, 3] t;
   algorithm
    t := t0;
   for i in 1:n loop
    t[1,1] := l * (t[2,1] + 75 + t[1,2] + 0) / 4 + (1-l) * t[1,1];
    t[2,1] := l * (t[3,1] + t[1,1] + t[2,2] + 0) / 4 + (1-l) * t[2,1];
    t[3,1] := l * (50 + t[2,1] + t[3,2] + 0) / 4 + (1-l) * t[3,1];
    t[1,2] := l * (t[2,2] + 75 + t[1,3] + t[1,1]) / 4 + (1-l) * t[1,2];
    t[2,2] := l * (t[3,2] + t[1,2] + t[2,3] + t[2,1]) / 4 + (1-l) * t[2,2];
    t[3,2] := l * (50 + t[2,2] + t[3,3] + t[3,1]) / 4 + (1-l) * t[3,2];
    t[1,3] := l * (75 + t[2,3] + 100 + t[1,2]) / 4 + (1-l) * t[1,3];
    t[2,3] := l * (t[3,3] + t[1,3] + 100 + t[2,2]) / 4 + (1-l) * t[2,3];
    t[3,3] := l * (50 + t[2,3] + 100 + t[3,2]) / 4 + (1-l) * t[3,3];
   end for;
  end temp;
  
  Real[3, 3] T;
  parameter Real l = 1.5 "overrelaxation value";
  parameter Real[3,3] T0 = {{0,0,0},{0,0,0},{0,0,0}} "initial t values";
  parameter Integer n = 9 "number of iterations";
 equation
  T = temp(l, T0, n);
  
end Ex24_1;
