model Ex25_3 "Cranck Nicholson solution of the heat conduction equation"

  function gausselim
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   input Boolean y;
   output Real[n] x;
   protected
    Integer piv = 0;
    Real[n] temp_a = zeros(n);
    Real temp_b = 0;
    Real m = 0;
    Real max = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
   if y == true then
    max := abs(a[i,i]);
    piv := i;
    for j in i+1:n loop
      if abs(a[j,i]) > max then
        max := abs(a[j,i]);
        piv := j;
      end if;
    end for;
      for l in 1:n loop
        temp_a[l] := a[piv,l];
      end for;
      temp_b := b[piv];
      for t in 1:n loop
        a[piv,t] := a[i,t];
      end for;
      b[piv] := b[i];
      for p in 1:n loop
        a[i,p] := temp_a[p];
      end for;
      b[i] := temp_b;
     end if;
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end gausselim;  

  function mat
    input Real a;
    output Real[4,4] m;
   algorithm
    m := zeros(4,4);
    for i in 1:4 loop
      m[i,i] := 2.04175;
    end for;
    for i in 1:3 loop
      m[i+1, i] := -0.020875;
      m[i, i+1] := -0.020875;
    end for;
  end mat;
  
  parameter Real[4] b1 = {4.175, 0, 0, 2.0875} "Ax = b; b corresponding to T^1";
  Real[4] b2 "Ax = b; b corresponding to T^2";
  Real[4] T1 "T^1";
  Real[4] T2 "T^2";
 equation
  T1 = gausselim(4, mat(1), b1, false);
  b2[2] = 4 * T1[2];
  b2[3] = 4 * T1[3];
  b2[1] = 4 * T1[1];
  b2[4] = 4 * T1[4];
  T2 = gausselim(4, mat(1), b2, false);

end Ex25_3;
