model Ex25_5 "ADI Method"

  function gausselim
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   input Boolean y;
   output Real[n] x;
   protected
    Integer piv = 0;
    Real[n] temp_a = zeros(n);
    Real temp_b = 0;
    Real m = 0;
    Real max = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
   if y == true then
    max := abs(a[i,i]);
    piv := i;
    for j in i+1:n loop
      if abs(a[j,i]) > max then
        max := abs(a[j,i]);
        piv := j;
      end if;
    end for;
      for l in 1:n loop
        temp_a[l] := a[piv,l];
      end for;
      temp_b := b[piv];
      for t in 1:n loop
        a[piv,t] := a[i,t];
      end for;
      b[piv] := b[i];
      for p in 1:n loop
        a[i,p] := temp_a[p];
      end for;
      b[i] := temp_b;
     end if;
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end gausselim;  

  function mat
    input Real a;
    output Real[3,3] m;
   algorithm
    m := zeros(3,3);
    for i in 1:3 loop
      m[i,i] := 2.167;
    end for;
    for i in 1:2 loop
      m[i+1, i] := -0.0835;
      m[i, i+1] := -0.0835;
    end for;
  end mat;
  
  Real[3,3] T1 "temperature values for first step";
  Real[3,3] T2 "temperature values for second step";
  Real[3] b1;
  Real[3] b2;
 equation
  b1 = {6.2625, 6.2625, 14.6125};
  b2 = {12.0639, 0.2577, 8.0619};
  {T1[1,1], T1[1,2], T1[1,3]} = gausselim(3, mat(1), b1, true);
  {T2[1,1], T2[2,1], T2[3,1]} = gausselim(3, mat(1), b2, true);
  T1[2,1] = 0.1274; T1[2,2] = 0.2900; T1[2,3] = 4.1291;
  T1[3,1] = 2.0181; T1[3,2] = 2.2477; T1[3,3] = 6.0256;
  T2[1,2] = 6.1683; T2[2,2] = 0.8238; T2[3,2] = 4.2359;
  T2[1,3] = 13.1120; T2[2,3] = 8.3207; T2[3,3] = 11.3606;
  
end Ex25_5;
