model Ex3_2 "Use of taylor series expansion to approximate a function with infinite derivatives"
  //default assuming h = pi/12
  Real x "variable";
  parameter Real pi = 3.14159265359;
  parameter Real n = 12 " h is of the form pi/n";
  parameter Real h = pi/n "use required value of n to get h of the form pi/n";
  //Real f "function f(x) = cos(x)";
  Real y0 "f(x) = cos(x) evaluated using taylor series approximation with n = 0";
  Real y1 "f(x) = cos(x) evaluated using taylor series approximation with n = 1";
  Real y2 "f(x) = cos(x) evaluated using taylor series approximation with n = 2";
  Real y3 "f(x) = cos(x) evaluated using taylor series approximation with n = 3";
  Real y4 "f(x) = cos(x) evaluated using taylor series approximation with n = 4";
  Real y5 "f(x) = cos(x) evaluated using taylor series approximation with n = 5";
  Real y6 "f(x) = cos(x) evaluated using taylor series approximation with n = 6";
equation
  x = time;
  y0 = cos(x-h);
  y1 = y0 - sin(x-h) * h;
  y2 = y1 - cos(x-h) * (h^2)/2;
  y3 = y2 + sin(x-h) * (h^3)/6;
  y4 = y3 + cos(x-h) * (h^4)/24;
  y5 = y4 - sin(x-h) * (h^5)/120;
  y6 = y5 - cos(x-h) * (h^6)/720;
  
end Ex3_2;
