model Ex4_4 "error estimates in bisection method"
//this example goes hand in hand with example 4.3 (Ex4_3) 
  function f
    input Real c;
    output Real y;
  algorithm
    y := 667.38 * (1 - exp(-0.146843 * c))/c - 40;
  end f;
  Real[6] x_u;
  Real[6] x_l;
  Real[6] x_r;
  Real[6] e_a "approximate percentage error";
  Real[6] e_t "true percentage error";
 equation
  x_u[1] = 16;
  x_l[1] = 12;
  x_r[1] = 14;
  e_a[1] = 14.2857;
  e_t[1] = abs((14.7802-x_r[1])/14.7802 * 100);
  for i in 2:6 loop
    if (f(x_r[i-1]) * f(x_l[i-1])) < 0 then
      x_l[i] = x_l[i-1];
      x_u[i] = x_r[i-1];
    else
      x_l[i] = x_r[i-1];
      x_u[i] = x_u[i-1];
    end if;
    x_r[i] = (x_l[i] + x_u[i])/2;
    e_a[i] = abs((x_u[i] - x_l[i])/(x_l[i] + x_u[i]) * 100);
    e_t[i] = abs((14.7802-x_r[i])/14.7802 * 100);
  end for;
end Ex4_4;
