model Ex4_6 "when bisection is preferable to false position"
  function f
    input Real c;
    output Real y;
  algorithm
    y := c^10 - 1;
  end f;
  Real[6] x_u_b "x_u for bisection method";
  Real[6] x_l_b "x_l for bisection method";
  Real[6] x_r_b "x_r for bisection method";
  Real[6] x_u_f "x_u for false position method";
  Real[6] x_l_f "x_l for false position method";
  Real[6] x_r_f "x_r for false position method";
  Real[6] e_a_b "approximate percentage error for bisection method";
  Real[6] e_t_b "true percentage error for bisection method";
  Real[6] e_a_f "approximate percentage error for false position method";
  Real[6] e_t_f "true percentage error for false position method";
 equation
  x_u_b[1] = 1.3;
  x_l_b[1] = 0;
  x_r_b[1] = 0.65;
  e_a_b[1] = 100;
  e_t_b[1] = abs((1-x_r_b[1])/1 * 100);
  
  x_u_f[1] = 1.3;
  x_l_f[1] = 0;
  x_r_f[1] = x_u_f[1] - f(x_u_f[1]) * (x_l_f[1] - x_u_f[1]) / (f(x_l_f[1]) - f(x_u_f[1]));
  e_a_f[1] = 100;
  e_t_f[1] = abs((1-x_r_f[1])/1 * 100);
  
  for i in 2:6 loop
    if (f(x_r_b[i-1]) * f(x_l_b[i-1])) < 0 then
      x_l_b[i] = x_l_b[i-1];
      x_u_b[i] = x_r_b[i-1];
    else
      x_l_b[i] = x_r_b[i-1];
      x_u_b[i] = x_u_b[i-1];
    end if;
    x_r_b[i] = (x_l_b[i] + x_u_b[i])/2;
    e_a_b[i] = abs((x_u_b[i] - x_l_b[i])/(x_l_b[i] + x_u_b[i]) * 100);
    e_t_b[i] = abs((1-x_r_b[i])/1 * 100);
  end for;
  
  for i in 2:6 loop
    if (f(x_r_f[i-1]) * f(x_l_f[i-1])) < 0 then
      x_l_f[i] = x_l_f[i-1];
      x_u_f[i] = x_r_f[i-1];
    else
      x_l_f[i] = x_r_f[i-1];
      x_u_f[i] = x_u_f[i-1];
    end if;
    x_r_f[i] = x_u_f[i] - f(x_u_f[i]) * (x_l_f[i] - x_u_f[i]) / (f(x_l_f[i]) - f(x_u_f[i]));
    e_a_f[i] = abs((x_r_f[i] - x_r_f[i-1])/x_r_f[i] * 100);
    e_t_f[i] = abs((1-x_r_f[i])/1 * 100);
  end for;
end Ex4_6;
