model Ex5_3 "Newton-raphson method"
  parameter Real x0 = 0 "starting point of iterations";
  Real[4] x "subsequent x_i";
  Real[4] e_t "total error";
 equation
  x[1] = x0 - (exp(-1 * x0) - x0)/(-1 * exp(-1 * x0) - 1);
  e_t[1] = (abs((0.56714329 - x[1])/0.56714329)) * 100;
  for i in 2:4 loop
    x[i] = x[i-1] - (exp(-1 * x[i-1]) - x[i-1])/(-1 * exp(-1 * x[i-1]) - 1);
    e_t[i] = (abs((0.56714329 - x[i])/0.56714329)) * 100;
  end for;
end Ex5_3;
