model Ex8_11 "Solution of linear algebraic equations using computer"
function gausselim
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   input Boolean y;
   output Real[n] x;
   protected
    Integer piv = 0;
    Real[n] temp_a = zeros(n);
    Real temp_b = 0;
    Real m = 0;
    Real max = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
   if y == true then
    max := abs(a[i,i]);
    piv := i;
    for j in i+1:n loop
      if abs(a[j,i]) > max then
        max := abs(a[j,i]);
        piv := j;
      end if;
    end for;
      for l in 1:n loop
        temp_a[l] := a[piv,l];
      end for;
      temp_b := b[piv];
      for t in 1:n loop
        a[piv,t] := a[i,t];
      end for;
      b[piv] := b[i];
      for p in 1:n loop
        a[i,p] := temp_a[p];
      end for;
      b[i] := temp_b;
     end if;
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end gausselim;
  
  parameter Real[3, 3] A = {{70, 1, 0}, {60, -1, 1}, {40, 0, -1}};
  parameter Real[3] B = {636, 518, 307};
  Real a;
  Real T;
  Real R;
  Real[3] x;
 equation
  x = gausselim(3, A, B, true);
  a = x[1];
  T = x[2];
  R = x[3];
end Ex8_11;
