model Ex8_5 "gauss elimination"
function d3
    input Real[3, 3] a;
    output Real y;
  algorithm
    y := a[3, 1] * (a[1, 2] * a[2, 3] - a[2, 2] * a[1, 3]) - a[3, 2] * (a[1, 1] * a[2, 3] - a[2, 1] * a[1, 3]) + a[3, 3] * (a[1,1] * a[2, 2] - a[1, 2] * a[2, 1]);
  end d3;
  parameter Real[3, 3] a = {{3, -0.1, -0.2}, {0.1, 7, -0.3}, {0.3, -0.2, 10}};
  parameter Real[3] b = {7.85, -19.3, 71.4};
  Real[3, 3] m1 "matrix corresponding to x1";
  Real[3, 3] m2 "matrix corresponding to x2";
  Real[3, 3] m3 "matrix corresponding to x3";
  Real x1;
  Real x2;
  Real x3;
 equation
  for i in 1:3 loop
    m1[i, 1] = b[i];
  end for;
  for i in 2:3 loop
    for j in 1:3 loop
      m1[j, i] = a[j, i];
    end for;
  end for;
  
  for i in 1:3 loop
    m3[i, 3] = b[i];
  end for;
  for i in 1:2 loop
    for j in 1:3 loop
      m3[j, i] = a[j, i];
    end for;
  end for;
  
  for i in 1:3 loop
    m2[i, 2] = b[i];
  end for;
  for i in 1:3 loop
    m2[i, 3] = a[i, 3];
  end for;
  for i in 1:3 loop
    m2[i, 1] = a[i, 1];
  end for;
  
  x1 = d3(m1) / d3(a);
  x2 = d3(m2) / d3(a);
  x3 = d3(m3) / d3(a);
end Ex8_5;
