model Ex12_3 "linear regression using the computer"
  function param
  input Integer n;
  input Real[n] y;
  input Real[n] x;
  output Real a0;
  output Real a1;
 protected
  Real xy = 0;
  Real x2 = 0;
  Real xs = 0;
  Real ys = 0;
 algorithm
  for i in 1:n loop
    xy := xy + x[i] * y[i];
  end for;
  for i in 1:n loop
    x2 := x2 + x[i] * x[i];
  end for;
  for i in 1:n loop
    xs := xs + x[i];
  end for;
  for i in 1:n loop
    ys := ys + y[i];
  end for;
  a1 := (n * xy - xs * ys)/(n * x2 - xs * xs);
  a0 := ys/n - a1 * xs/n;
 end param;
 
 parameter Real[15] t = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
 parameter Real[15] va_i = {10,16.3,23,27.5,31,35.6,39,41.5,42.9,45,46,45.5,46,49,50};
 Real[15] vb_i "velocities for Eq.(1.10)";
 Real[15] vc_i "velocities for Eq.(E12.3.1)"; 
 Real va;
 Real vb;
 Real vc;
 Real a1_b "a1 for vb vs va";
 Real a0_b "a0 for vb vs va";
 Real a1_c "a1 for vc vs va";
 Real a0_c "a0 for vc vs va";
equation
  for i in 1:15 loop
    vb_i[i] = 9.8 * 68.1 / 12.5 * (1 - exp(-12.5/68.1 * t[i]));
    vc_i[i] = 9.8 * 68.1 / 12.5 * (t[i] / (3.75 + t[i]));
  end for;
  (a0_b, a1_b) = param(15, vb_i, va_i);
  (a0_c, a1_c) = param(15, vc_i, va_i);
  va = time;
  vb = a0_b + a1_b * va;
  vc = a0_c + a1_c * va;
end Ex12_3;
