model Ex12_7 "confidence values for linear regression"

function gausselim
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   input Boolean y;
   output Real[n] x;
   protected
    Integer piv = 0;
    Real[n] temp_a = zeros(n);
    Real temp_b = 0;
    Real m = 0;
    Real max = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
   if y == true then
    max := abs(a[i,i]);
    piv := i;
    for j in i+1:n loop
      if abs(a[j,i]) > max then
        max := abs(a[j,i]);
        piv := j;
      end if;
    end for;
      for l in 1:n loop
        temp_a[l] := a[piv,l];
      end for;
      temp_b := b[piv];
      for t in 1:n loop
        a[piv,t] := a[i,t];
      end for;
      b[piv] := b[i];
      for p in 1:n loop
        a[i,p] := temp_a[p];
      end for;
      b[i] := temp_b;
     end if;
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end gausselim;

 Real[15, 2] Z;
 Real[15] y;
 Real[2] a;
 Real s_a0;
 Real s_a1;
equation
  Z = [1, 10;1,16.3;1,23;1,27.5;1,31;1,35.6;1,39.00;1,41.5;1,42.9;1,45;1,46;1,45.5;1,46;1,49;1,50];
  for i in 1:15 loop
    y[i] = 9.8 * 68.1 / 12.5 * (1 - exp(-12.5 / 68.1 * i));
  end for;
  a = gausselim(2, transpose(Z) * Z, transpose(Z) * y, false);
  s_a0 = sqrt(0.688414 * (0.863403)^2);
  s_a1 = sqrt(0.000465 * (0.863403)^2);
end Ex12_7;
