model Ex13_8 "first-order splines"

  Real x;
  Real f1;
  Real f2;
  Real f3;
  // f1, f2, f3 are the three functions that interpolate this spline. plot all three functions together to see the spline
  parameter Real[4] xi = {3.0, 4.5, 7.0, 9.0};
  parameter Real[4] fi = {2.5, 1.0, 2.5, 0.5};
  Real m1;
  Real m2;
  Real m3;
 equation
  x = time;
  m1 = (fi[2] - fi[1])/(xi[2] - xi[1]);
  m2 = (fi[3] - fi[2])/(xi[3] - xi[2]);
  m3 = (fi[4] - fi[3])/(xi[4] - xi[3]);
  f1 = fi[1] + m1 * (time - xi[1]);
  f2 = fi[2] + m2 * (time - xi[2]);
  f3 = fi[3] + m3 * (time - xi[3]);
end Ex13_8;
