model Ex13_9 "quadratic splines"

  function gausselim
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   input Boolean y;
   output Real[n] x;
   protected
    Integer piv = 0;
    Real[n] temp_a = zeros(n);
    Real temp_b = 0;
    Real m = 0;
    Real max = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
   if y == true then
    max := abs(a[i,i]);
    piv := i;
    for j in i+1:n loop
      if abs(a[j,i]) > max then
        max := abs(a[j,i]);
        piv := j;
      end if;
    end for;
      for l in 1:n loop
        temp_a[l] := a[piv,l];
      end for;
      temp_b := b[piv];
      for t in 1:n loop
        a[piv,t] := a[i,t];
      end for;
      b[piv] := b[i];
      for p in 1:n loop
        a[i,p] := temp_a[p];
      end for;
      b[i] := temp_b;
     end if;
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end gausselim;
  import Modelica. Math.Matrices;
  function gena
    input Real n;
    output Real[8, 8] a;
   algorithm
    a := zeros(8, 8);
  a[1, 1] := 4.5;
  a[1, 2] := 1;
  a[2, 3] := 20.25;
  a[2, 4] := 4.5;
  a[2, 5] := 1;
  a[3, 3] := 49;
  a[3, 4] := 7;
  a[3, 5] := 1;
  a[4, 6] := 49;
  a[4, 7] := 7;
  a[4, 8] := 1;
  a[5, 1] := 3;
  a[5, 2] := 1;
  a[6, 6] := 81;
  a[6, 7] := 9;
  a[6, 8] := 1;
  a[7, 1] := 1;
  a[7, 3] := -9;
  a[7, 4] := -1;
  a[8, 3] := 14;
  a[8, 4] := 1;
  a[8, 6] := -14;
  a[8, 7] := -1;
 end gena;
  
  Real f1;
  Real f2;
  Real f3;
  Real x;
  Real f_5 "value of function at 5 calculated using interpolation";
  Real[8, 8] a;
  Real[8] b;
 equation
  x = time;
  a = gena(8);
  b = {1,1,2.5,2.5,2.5,0.5,0,0};
  f1 = -1*x + 5.5;
  f2 = 0.64*x^2 - 6.76*x + 18.46;
  f3 = -1.6*x^2 + 24.6*x - 91.3;
  f_5 = 0.64*5^2 - 6.76*5 + 18.46;
end Ex13_9;
