model Ex14_1 "least-squares fit of a sinusoid"
  
  parameter Real[10] ti = {0,0.15,0.30,0.45,0.60,0.75,0.90,1.05,1.20,1.35} "values of time";
  parameter Real w = 4.189 "omega";
  Real[10] yi;
  Real[10] f1 "yi * cos(w*ti)";
  Real[10] f2 "yi * sin(w*ti)";
  Real y "function obtained";
  Real t "time axis";
  Real A0;
  Real A1;
  Real B1;
 equation
  t = time;
  for i in 1:10 loop
    yi[i] = 1.7 + cos(4.189*ti[i] + 1.0472);
    f1[i] = yi[i] * cos(w * ti[i]);
    f2[i] = yi[i] * sin(w * ti[i]);
  end for;
  A0 = sum(yi) / 10;
  A1 = 2 * sum(f1) / 10;
  B1 = 2 * sum(f2) / 10;
  y = A0 + A1 * cos(w*t) - B1 * sin(w * t);
end Ex14_1;
