model Ex16_5 "multiple applications of simpson's 1/3 rule"

  function f
    input Real x;
    output Real y;
   algorithm
    y := 0.2 + 25*x - 200*x^2 + 675 * x^3 - 900*x^4 + 400 * x^5;
  end f;
  
  function fd
    input Real x;
    output Real y;
   algorithm
    y := 0.2*x + 25*x^2 / 2 - 200*x^3 / 3 + 675 * x^4 / 4 - 900*x^5 / 5 + 400 * x^6 / 6;
  end fd;
  
  parameter Real a = 0;
  parameter Real b = 0.8;
  Real n = 4 "number of intervals";
  Real h;
  Real I "value of integral using simpson's rule";
  Real Et "error";
  Real et "relative error";
 equation
  h = (b-a) / n;
  I = (b-a) * ( f(a) + 4 * (f(a+h) + f(a+3*h)) + 2 * (f(a+2*h))  + f(b) ) / (3*n);
  Et = fd(b) - fd(a) - I;
  et = Et / (fd(b) - fd(a)) * 100;


end Ex16_5;
