model Ex17_1 "Error corrections of the trapezoidal rule"

   function f
    input Real x;
    output Real y;
   algorithm
    y := 0.2 + 25*x - 200*x^2 + 675 * x^3 - 900*x^4 + 400 * x^5;
  end f;

  function fd
    input Real x;
    output Real y;
   algorithm
    y := 0.2*x + 25*x^2 / 2 - 200*x^3 / 3 + 675 * x^4 / 4 - 900*x^5 / 5 + 400 * x^6 / 6;
  end fd;

  Real[3] segments;
  Real[3] h;
  Real[3] integral;
  Real I_12 "integral for one and two segments";
  Real I_24 "integral for two and four segments";
  Real Et_12 "error for one and two segments";
  Real et_12 "relative error for one and two segments";
  Real Et_24 "error for two and for segments";
  Real et_24 "relative error for two and four segments";
 equation
  segments = {1, 2, 4};
  h = {0.8, 0.4, 0.2};
  integral = {0.1728, 1.0688, 1.4848};
  I_12 = 4/3 * integral[2] - 1/3 * integral[1];
  I_24 = 4/3 * integral[3] - 1/3 * integral[2];
  Et_12 = fd(0.8) - fd(0) - I_12;
  et_12 = Et_12 / (fd(0.8) - fd(0)) * 100;
  Et_24 = fd(0.8) - fd(0) - I_24;
  et_24 = Et_24 / (fd(0.8) - fd(0)) * 100;
end Ex17_1;
