model Ex20_1 "euler's method"

function f
  input Real x;
  output Real y;
 algorithm
  y := -2*x^3 + 12*x^2 - 20*x + 8.5;
 end f;
 
 function sol
  input Real x;
  output Real y;
 algorithm
  y := -(x^4)/2 + 4*x^3 - 10*x^2 + 8.5*x + 1;
 end sol;
 
 parameter Real x0 = 0 "initial x";
 parameter Real xf = 4 "final x";
 parameter Real h = 0.5 "step size";
 parameter Integer n = integer(ceil((xf-x0)/h));
 Real[n+1] y;
 Real[n+1] x;
 Real[n+1] e "y_true - y_euler";
equation
 x[1] = x0;
 y[1] = 1;
 e[1] = 0;
 for i in 1:n loop
  y[i+1] = y[i] + f(x[i]) * h;
  x[i+1] = x[i] + h;
  e[i+1] = sol(x[i+1]) - y[i+1];
  end for;
end Ex20_1;
