model Ex21_2 "Non Slf starting heun method"
//the correction has been done upto two steps in each iteration
  function f
    input Real x;
    input Real y;
    output Real dy;
   algorithm
    dy := 4 * exp(0.8 * x) - 0.5 * y;
  end f;
  
  Real[5] x;
  Real[5] yp "predicted value";
  Real[5] yc1 "corrected value after one iteration";
  Real[5] yc2 "corrected value after second iteration";
 equation
  x = {0, 1, 2, 3, 4};
  yp[1] = 2;
  yc1[1] = 2;
  yc2[1] = 2;
  yp[2] = 5.607005;
  yc1[2] = 6.549331;
  yc2[2] = 6.313749;
  for i in 3:5 loop
    yp[i] = yc2[i-2] + f(x[i-1], yc2[i-1]) * 2 * 1;
    yc1[i] = yc2[i-1] + 0.5 * (f(x[i-1], yc2[i-1]) + f(x[i], yp[i]));
    yc2[i] = yc2[i-1] + 0.5 * (f(x[i-1], yc2[i-1]) + f(x[i], yc1[i]));
  end for;

end Ex21_2;
