model Ex3_6 "multivariable function error propagation"
  Real y;
  Real dy "error in y";
  parameter Real F(unit = "lb/ft") = 50;
  parameter Real dF(unit = "lb/ft") = 2 "error in F";
  parameter Real L(unit = "ft") = 30;
  parameter Real dL(unit = "ft") = 0.1 "error in L";
  parameter Real E(unit = "lb/ft^2") = 1.5 * 10^8;
  parameter Real dE(unit = "lb/ft^2") = 0.01 * 10^8 "error in E";
  parameter Real I(unit = "ft^4") = 0.06;
  parameter Real dI(unit = "ft^4") = 0.0006 "error in I";
 equation
  y = (F * L^4)/(8 * E * I);
  dy = (L^4 * dF)/(8 * E * I) + (F * L^3 * dL)/(2 * E * I) + (F * L^4 * dE)/(8 * E^2 * I) + (F * L^4 * dI)/(8 * E * I^2);
end Ex3_6;
