model Ex4_3 "bisection method"
//this example goes hand in hand with example 4.4 (Ex4_4) 
  function f
    input Real c;
    output Real y;
  algorithm
    y := 667.38 * (1 - exp(-0.146843 * c))/c - 40;
  end f;
  Real[6] x_u;
  Real[6] x_l;
  Real[6] x_r;
 equation
  x_u[1] = 16;
  x_l[1] = 12;
  x_r[1] = 14;
  for i in 2:6 loop
    if (f(x_r[i-1]) * f(x_l[i-1])) < 0 then
      x_l[i] = x_l[i-1];
      x_u[i] = x_r[i-1];
    else
      x_l[i] = x_r[i-1];
      x_u[i] = x_u[i-1];
    end if;
    x_r[i] = (x_l[i] + x_u[i])/2;
  end for;
end Ex4_3;
