model Ex5_7 "comparison of convergence for secant and false position methods"
//f(x) = ln(x)
  function f
    input Real c;
    output Real y;
  algorithm
    y := log(c);
  end f;
  
  function xn
    input Real x_l;
    input Real x_u;
    output Real y;
   algorithm
    y := x_u - f(x_u) * (x_l - x_u) / (f(x_l) - f(x_u));
  end xn;
  
  parameter Real x_l_0 = 0.5 "first initial value of x";
  parameter Real x_u_0 = 5.0 "second initial value of x";
  Real[3] x_l_f "subsequent x_l for false position method";
  Real[3] x_u_f "subsequent x_u for false position method";
  Real[2] x_u_s "subsequent x_u for secant method";
  Real[2] x_l_s "subsequent x_l for secant method";
  Real[3] x_r_f "subsequent x_r for false position method";
  Real[2] x_r_s "subsequent x_r for secant method";
  
 equation
 
  x_l_s[1] = x_l_0;
  x_l_f[1] = x_l_0;
  x_u_f[1] = x_u_0;
  x_u_s[1] = x_u_0;
  x_r_f[1] = xn(x_l = x_l_f[1], x_u = x_u_f[1]);
  for i in 2:3 loop
    if (f(x_l_f[i-1]) * f(x_r_f[i-1])) < 0 then
      x_l_f[i] = x_l_f[i-1];
      x_u_f[i] = x_r_f[i-1];
    else
      x_l_f[i] = x_r_f[i-1];
      x_u_f[i] = x_u_f[i-1];
    end if;
    x_r_f[i] = xn(x_l = x_l_f[i-1], x_u = x_u_f[i-1]);
  end for;
  
  x_r_s[1] = xn(x_l = x_l_s[1], x_u = x_u_s[1]);
  x_l_s[2] = x_u_s[1];
  x_u_s[2] = x_r_s[1];
  x_r_s[2] = xn(x_l = x_l_s[2], x_u = x_u_s[2]);
  
end Ex5_7;
