model Ex9_4 "matrix condition evaluation"

  Real[3, 3] a;
  Real a_norm "infinity norm of a";
  Real[3, 3] a_inv "inverse of a";
  Real a_inv_norm "norm of a inverse";
  Real cond "condition number";
 equation
  a = {{1, 1/2, 1/3}, {1, 2/3, 1/2}, {1, 3/4, 3/5}};
  a_norm = max(abs(a[1, 1]) + abs(a[1, 2]) + abs(a[1, 3]), max(abs(a[2, 1]) + abs(a[2, 2]) + abs(a[2, 3]), abs(a[3, 1]) + abs(a[3, 2]) + abs(a[3, 3])));
  a_inv = {{9, -18, 10}, {-36, 96, -60}, {30, -90, 60}};
  a_inv_norm = max(abs(a_inv[1, 1]) + abs(a_inv[1, 2]) + abs(a_inv[1, 3]), max(abs(a_inv[2, 1]) + abs(a_inv[2, 2]) + abs(a_inv[2, 3]), abs(a_inv[3, 1]) + abs(a_inv[3, 2]) + abs(a_inv[3, 3])));
  cond = a_norm * a_inv_norm;

end Ex9_4;
