model Ex1_2 "Numerical Solution : the Falling Parachutist"
  parameter Real m(unit = "kg") = 68.1 "mass of parachutist";
  parameter Real c(unit = "kg/s")  = 12.5 "drag coefficient";
  parameter Real g(unit = "m/s2") = 9.8 "acceleration due to gravity";
  Real v2(unit = "m/s") "velocity at t = 2s";
  Real v4(unit = "m/s") "velocity at t = 4s";
  Real v6(unit = "m/s") "velocity at t = 6s";
  Real v8(unit = "m/s") "velocity at t = 8s";
equation
  v2 = 0 + (9.8 - 12.5/68.1*0)*2;
  v4 = v2 + (9.8 - 12.5/68.1*v2)*2;
  v6 = v4 + (9.8 - 12.5/68.1*v4)*2;
  v8 = v6 + (9.8 - 12.5/68.1*v6)*2;
end Ex1_2;
