model Ex10_3 "Gauss-Siedel"
  function gs
    input Integer n;
    input Real[3] x0;
    input Real[3, 3] a;
    input Real[3] b;
    output Real[3] x;
   algorithm
    x := x0;
    for i in 1:n loop
      x[1] := (7.85 + 0.1 * x[2] + 0.2 * x[3])/3;
      x[2] := (-19.3 - 0.1 * x[1] + 0.3 * x[3])/7;
      x[3] := (71.4 - 0.3 * x[1] + 0.2 * x[2])/10;
    end for;
   end gs;
   
   parameter Real[3, 3] a = {{3, -0.1, -0.2}, {0.1, 7, -0.3}, {0.3, -0.2, 10}};
   parameter Real[3] b = {7.85, -19.3, 71.4};
   parameter Real[3] x0 = {0, 0, 0} "initial guess value";
   parameter Integer n = 2 "number of iterations";
   Real[3] x "solution";
  equation
   x = gs(n, x0, a, b);
end Ex10_3;
