model Ex12_9 "gauss-newton method"
function pd
  input Real a0;
  input Real a1;
  input Real x;
  output Real f0;
  output Real f1;
 algorithm
  f0 := 1 - exp(-a1 * x);
  f1 := a0 * x * exp(-a1 * x);
 end pd;
 
 function gausselim
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   input Boolean y;
   output Real[n] x;
   protected
    Integer piv = 0;
    Real[n] temp_a = zeros(n);
    Real temp_b = 0;
    Real m = 0;
    Real max = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
   if y == true then
    max := abs(a[i,i]);
    piv := i;
    for j in i+1:n loop
      if abs(a[j,i]) > max then
        max := abs(a[j,i]);
        piv := j;
      end if;
    end for;
      for l in 1:n loop
        temp_a[l] := a[piv,l];
      end for;
      temp_b := b[piv];
      for t in 1:n loop
        a[piv,t] := a[i,t];
      end for;
      b[piv] := b[i];
      for p in 1:n loop
        a[i,p] := temp_a[p];
      end for;
      b[i] := temp_b;
     end if;
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end gausselim;
  
  Real[5, 2] z;
  parameter Real[5] x = {0.25,0.75,1.25,1.75,2.25};
  parameter Real[5] y = {0.28,0.57,0.68,0.74,0.79};
  Real[2] da "delta A";
  Real[5] d;
  Real a0;
  Real a1;
 equation
  for i in 1:5 loop
    (z[i, 1], z[i, 2]) = pd(1, 1, x[i]);
  end for;
  for i in 1:5 loop
    d[i] = y[i] - z[i, 1];
  end for;
   da = gausselim(2, transpose(z) * z, transpose(z) * d, false);
  a0 = 1 + da[1];
  a1 = 1 + da[2];
  
end Ex12_9;
