model Ex13_6 "lagrange interpolating polynomials"

  parameter Real[3] xi = {1, 4, 6};
  parameter Real x_in = 2 " value of x where to find ln(x_in)";
  Real[3] fi;
  Real f2 "f(x) using second order lagarange interpolation";
  Real f1 "f(x) using first order lagarange interpolation";
  Real f1_in "ln(x_in) using first order lagarange";
  Real f2_in "ln(x_in) using second order lagarange";
  Real x;
 equation
  for i in 1:3 loop
    fi[i] = log(xi[i]);
  end for;
  x = time;
  f1 = (x - xi[2])/(xi[1] - xi[2])*fi[1] + (x - xi[1])/(xi[2] - xi[1])*fi[2];
  f2 = (x - xi[2]) * (x-xi[3])/(xi[1] - xi[2])/(xi[1] - xi[3])*fi[1] + (x - xi[1])*(x-xi[3])/(xi[2] - xi[3])/(xi[2] - xi[1])*fi[2] + (x-xi[1])*(x-xi[2])/(xi[3]-xi[1])/(xi[3]-xi[2])*fi[3];
  f1_in = (x_in - xi[2])/(xi[1] - xi[2])*fi[1] + (x_in - xi[1])/(xi[2] - xi[1])*fi[2];
  f2_in = (x_in - xi[2]) * (x_in-xi[3])/(xi[1] - xi[2])/(xi[1] - xi[3])*fi[1] + (x_in - xi[1])*(x_in-xi[3])/(xi[2] - xi[3])/(xi[2] - xi[1])*fi[2] + (x_in-xi[1])*(x_in-xi[2])/(xi[3]-xi[1])/(xi[3]-xi[2])*fi[3];

end Ex13_6;
