model Ex18_2 "richardson extrapolation"

  function f
    input Real x;
    output Real y;
   algorithm
    y := -0.1 * x^4 - 0.15 * x^3 - 0.5 * x^2 - 0.25 * x + 1.2;
  end f;
  
  function fd
    input Real x;
    output Real y;
   algorithm
    y := -0.1 * 4 * x^3 - 0.15 * 3 * x^2 - 0.5 * 2 * x - 0.25;
  end fd;
  
  parameter Real h1 = 0.5 "first value of step size";
  parameter Real h2 = 0.25 "second value of step size";
  parameter Real x0 = 0.5 "value pf x at which derivative is to be calculated";
  Real[3] x1;
  Real[3] f1;
  Real[3] x2;
  Real[3] f2;
  Real d1 "derivative using h1";
  Real d2 "derivative using h2";
  Real d "true derivative at x0";
  Real dr "derivative using richardson extrapolation";
 equation
  d = fd(x0);
  x1[1] = x0 - h1;
  x1[2] = x0;
  x1[3] = x0 + h1;
  x2[1] = x0 - h2;
  x2[2] = x0;
  x2[3] = x0 + h2;
  for i in 1:3 loop
    f1[i] = f(x1[i]);
    f2[i] = f(x2[i]);
  end for;
  d1 = ( f1[3] - f1[1] ) / (2 * h1);
  d2 = ( f2[3] - f2[1] ) / (2 * h2);
  dr = 4/3 * d2 - 1/3 * d1;
end Ex18_2;
