model Ex2_1 "Error Calculation"
  parameter Real l_bm(unit = "cm") = 9999 "measured length of bridge";
  parameter Real l_rm(unit = "cm") = 9 "measured length of rivet";
  parameter Real l_bt(unit = "cm") = 10000 "true length of bridge";
  parameter Real l_rt(unit = "cm") = 10 "true length of rivet";
  Real E_tb(unit = "cm") "true error in measuring bridge";
  Real E_tr(unit = "cm") "true error in measuring rivet";
  Real e_tb(unit = "%") "relative error in measuring bridge";
  Real e_tr(unit = "%") "relative error in measuring rivet";
 equation
  E_tb = l_bt - l_bm;
  E_tr = l_rt - l_rm;
  e_tb = E_tb/l_bt*100;
  e_tr = E_tr/l_rt*100;
end Ex2_1;
