model Ex20_4 "solving ODEs with the computer - Parachutist Problem"
function f
  input Real v;
  input Real a;
  input Real b;
  input Real c;
  input Real g;
  input Real m;
  input Real v_m;
  output Real y;
 algorithm
  y := g - c/m * (v + a * (v/v_m)^b);
 end f;
 
  parameter Real a = 8.3;
  parameter Real b = 2.2;
  parameter Real c = 12.5;
  parameter Real g = 9.8;
  parameter Real m = 68.1;
  parameter Real v_max = 46;
  parameter Real h = 0.1 "step size";
  parameter Real tf = 15 "final time";
  parameter Real t0 = 0 "initial time";
  parameter Real v0 = 0 "initial velocity";
  Real[n+1] t;
  Real[n+1] v;
  parameter Integer n = integer(ceil((tf-t0)/h));
 equation
  t[1] = t0;
  v[1] = v0;
  for i in 1:n loop
   t[i+1] = t[i] + h;
   v[i+1] = v[i] + f(v[i], a, b, c, g, m, v_max) * h;
   end for;
end Ex20_4;
