model Ex20_5 "heun's method"

function f
  input Real x;
  input Real y;
  output Real fun;
 algorithm
  fun := 4 * exp(0.8 * x) - 0.5 * y;
 end f;
 
 parameter Real x0 = 0;
 parameter Real xf = 4;
 parameter Real y0 = 2;
 parameter Real h = 1;
 parameter Integer n = integer(ceil((xf-x0)/h));
 Real[n+1] x;
 Real[n+1] y_p "predicted value of y usng explicit euler";
 Real[n+1] y "corrected value of y using heun's method";
equation
 x[1] = x0;
 y_p[1] = y0;
 y[1] = y0;
 for i in 1:n loop
  x[i+1] = x[i] + h;
  y_p[i+1] = y[i] + f(x[i], y[i]) * h;
  y[i+1] = y[i] + h/2 * (f(x[i], y[i]) + f(x[i+1], y_p[i+1]));
  end for;

end Ex20_5;
