model Ex24_2 "Flux distribution for a heated plate"

  function temp
    input Real l;
    input Real[3,3] t0;
    input Integer n;
    output Real[3, 3] t;
   algorithm
    t := t0;
   for i in 1:n loop
    t[1,1] := l * (t[2,1] + 75 + t[1,2] + 0) / 4 + (1-l) * t[1,1];
    t[2,1] := l * (t[3,1] + t[1,1] + t[2,2] + 0) / 4 + (1-l) * t[2,1];
    t[3,1] := l * (50 + t[2,1] + t[3,2] + 0) / 4 + (1-l) * t[3,1];
    t[1,2] := l * (t[2,2] + 75 + t[1,3] + t[1,1]) / 4 + (1-l) * t[1,2];
    t[2,2] := l * (t[3,2] + t[1,2] + t[2,3] + t[2,1]) / 4 + (1-l) * t[2,2];
    t[3,2] := l * (50 + t[2,2] + t[3,3] + t[3,1]) / 4 + (1-l) * t[3,2];
    t[1,3] := l * (75 + t[2,3] + 100 + t[1,2]) / 4 + (1-l) * t[1,3];
    t[2,3] := l * (t[3,3] + t[1,3] + 100 + t[2,2]) / 4 + (1-l) * t[2,3];
    t[3,3] := l * (50 + t[2,3] + 100 + t[3,2]) / 4 + (1-l) * t[3,3];
   end for;
  end temp;
  
  Real[3, 3] T;
  parameter Real l = 1.5 "overrelaxation value";
  parameter Real[3,3] T0 = {{0,0,0},{0,0,0},{0,0,0}} "initial t values";
  parameter Integer n = 9 "number of iterations";
  parameter Real k(unit = "cal/(s * cm * C)") = 0.49 " specific conductivity";
  parameter Real s(unit = "cm") = 40 "side of the plate";
  Real q_x(unit = "cal/(cm^2 * s)");
  Real q_y(unit = "cal/(cm^2 * s)");
  Real q_n(unit = "cal/(cm^2 * s)");
  Real theta(unit = "degrees");
 equation
  T = temp(l, T0, n);
  q_x = -k * (T[2,1] - 75) * 2 /s;
  q_y = -k * (T[1,2] - 0) * 2 /s;
  q_n = sqrt((q_x)^2 + (q_y)^2);
  if q_x>0 then
    theta = atan(q_y / q_x) * 180 / 3.14159265;
  else
    theta = atan(q_y / q_x) * 180 / 3.14159265 + 180;
  end if;
end Ex24_2;
