model Ex3_4 "approximations of derivatives, finite divided difference"
//f(x) = -0.1*x^4 - 0.15*x^3 - 0.5*x^2 - 0.25*x + 1.2
//f'(x) = -0.4*x^3 - 0.45*x^2 - 1.0*x - 0.25
  parameter Real h = 0.5 "Change the values of h to see what effect it has on the derivatives";
  Real x;
  Real derf "actual derivative of x";
  Real derf_f "derivative of f using forward approximation";
  Real derf_b "derivative of f using backward approximation";
  Real derf_cd "derivative of f using centred difference approximation";
  Real e_f "relative percentage error in finding derivative of f using forward approximation";
  Real e_b "relative percentage error in finding derivative of f using forward approximation";
  Real e_cd "relative percentage error in finding derivative of f using centred difference approximation";
 equation
  x = time;
  derf = der(-0.1*(x^4) - 0.15*(x^3) - 0.5*(x^2) - 0.25*x + 1.2);
  derf_f = ((-0.1*((x+h)^4) - 0.15*((x+h)^3) - 0.5*((x+h)^2) - 0.25*(x+h) + 1.2) - (-0.1*(x^4) - 0.15*(x^3) - 0.5*(x^2) - 0.25*x + 1.2))/h;
  derf_b = ((-0.1*(x^4) - 0.15*(x^3) - 0.5*(x^2) - 0.25*x + 1.2) - (-0.1*((x-h)^4) - 0.15*((x-h)^3) - 0.5*((x-h)^2) - 0.25*(x-h) + 1.2))/h;
  derf_cd = ((-0.1*((x+h)^4) - 0.15*((x+h)^3) - 0.5*((x+h)^2) - 0.25*(x+h) + 1.2) - (-0.1*((x-h)^4) - 0.15*((x-h)^3) - 0.5*((x-h)^2) - 0.25*(x-h) + 1.2))/(2*h);
  e_f = abs((derf_f - derf)/derf)*100;
  e_b = abs((derf - derf_b)/derf)*100;
  e_cd = abs((derf_cd - derf)/derf)*100;
end Ex3_4;
