model Ex5_5 "slowly converging function with newton raphson"
  parameter Integer n = 45 "number of iterations";
  parameter Real x0 = 0.5 "initial guess";
  Real[n] x "subsequent iterations";
 equation
  x[1] = x0 - (((x0)^10) - 1)/(10 * ((x0)^9));
  for i in 2:n loop
    x[i] = x[i-1] - (((x[i-1])^10) - 1)/(10 * ((x[i-1])^9));
  end for;
end Ex5_5;
