model Ex5_8 "modified secant method"
  function f
    input Real c;
    output Real y;
  algorithm
    y := exp(-1*c) - c;
  end f;
  parameter Real x0 = 1.0 "initial guess";
  Real[3] x "subsequent iterations";
  Real[3] e_t "true percent error for each iteration";
  Real xt "true root";
  parameter Real s = 0.01 "perterbation factor";
 equation
  xt = 0.56714329;
  x[1] = x0 - s * x0 * f(x0) / (f(x0 + s * x0) - f(x0));
  e_t[1] = abs((xt - x[1])/xt) * 100;
  
  x[2] = x[1] - s * x[1] * f(x[1]) / (f(x[1] + s * x[1]) - f(x[1]));
  e_t[2] = abs((xt - x[2])/xt) * 100;
  
  x[3] = x[2] - s * x[2] * f(x[2]) / (f(x[2] + s * x[2]) - f(x[2]));
  e_t[3] = abs((xt - x[3])/xt) * 100;
end Ex5_8;
