model Ex5_9 "modified newton raphson method"
  function f
   input Real  c;
   output Real y;
  algorithm
   y := (c-3) * (c-1) * (c-1);
  end f;
  function df
   input Real c;
   output Real y;
  algorithm
    y := 3 * c^2 - 10 * c + 7;
  end df;
  function ddf
    input Real c;
    output Real y;
  algorithm
    y := 6 * c - 10;
  end ddf;
  
  Real[8] x_o "successive iterations using old newton raphson";
  Real[8] x_n "successive iterations using new newton raphson";
  parameter Real x0 = 0 "initial guess";
 equation
  x_o[1] = x0 - f(x0)/df(x0);
  x_n[1] = x0 - (f(x0) * df(x0)) / ( df(x0) * df(x0) - f(x0) * ddf(x0) );
  for i in 2:8 loop
    x_o[i] = x_o[i-1] - f(x_o[i-1])/df(x_o[i-1]);
    x_n[i] = x_n[i-1] - f(x_n[i-1]) * df(x_n[i-1]) / ((df(x_n[i-1]))^2 - f(x_n[i-1]) * ddf(x_n[i-1]));
  end for;
end Ex5_9;
