model Ex8_10 "effect of scaling on pivoting and round off"
//by default this simulation is for part(a) of the problem.
//For other parts, scale the matrices as required and change them in the simulation window and re-simulate.

function gausselim
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   input Boolean y;
   output Real[n] x;
   protected
    Integer piv = 0;
    Real[n] temp_a = zeros(n);
    Real temp_b = 0;
    Real m = 0;
    Real max = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
   if y == true then
    max := abs(a[i,i]);
    piv := i;
    for j in i+1:n loop
      if abs(a[j,i]) > max then
        max := abs(a[j,i]);
        piv := j;
      end if;
    end for;
      for l in 1:n loop
        temp_a[l] := a[piv,l];
      end for;
      temp_b := b[piv];
      for t in 1:n loop
        a[piv,t] := a[i,t];
      end for;
      b[piv] := b[i];
      for p in 1:n loop
        a[i,p] := temp_a[p];
      end for;
      b[i] := temp_b;
     end if;
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end gausselim;
  
  parameter Integer n = 2 "number of equations";
  parameter Real[n, n] a = {{2, 100000}, {1, 1}};
  parameter Real[n] b = {100000, 2};
  Real[n] x;
 equation
  x = gausselim(n, a, b, true);
end Ex8_10;
