model Ex1_1 "Solution to the Falling Parachutist Problem"
  parameter Real m(unit = "kg") = 68.1 "mass of parachutist";
  parameter Real c(unit = "kg/s")  = 12.5 "drag coefficient";
  parameter Real g(unit = "m/s2") = 9.8 "acceleration due to gravity";
  Real v(start = 0.00, unit = "m/s") "velocity";
equation
  v = (g*m/c)*(1-exp(-c/m*time));
end Ex1_1;
