model Ex13_4 " Error Estimate for newton's polynomial"
  parameter Real[4] xi = {1, 4, 6, 5};
  parameter Real x2 = 2 " value of x where to find ln(x2)";
  Real[4] f0 "0th finite divided difference";
  Real[3] f1 "1st finite divided difference";
  Real[2] f2 "2nd finite divided difference";
  Real[1] f3 "3rd finite divided difference";
  Real R2_2 "R2 at x = 2";
  Real R2;
  Real x;
 equation
  x = time;
  for i in 1:4 loop
    f0[i] = log(xi[i]);
  end for;
  for i in 1:3 loop
    f1[i] = (f0[i+1] - f0[i])/(xi[i+1] - xi[i]);
  end for;
  for i in 1:2 loop
    f2[i] = (f1[i+1] - f1[i]) / (xi[i+2] - xi[i]);
  end for;
  f3[1] = (f2[2] - f2[1]) / (xi[4] - xi[1]);
  R2 = f3[1] * (x - xi[1]) * (x - xi[2]) * (x - xi[3]);
  R2_2 = f3[1] * (2 - xi[1]) * (2 - xi[2]) * (2 - xi[3]);
end Ex13_4;
