model Ex16_6 "simpson's 3/8 rule"

  function f
    input Real x;
    output Real y;
   algorithm
    y := 0.2 + 25*x - 200*x^2 + 675 * x^3 - 900*x^4 + 400 * x^5;
  end f;
  
  function fd
    input Real x;
    output Real y;
   algorithm
    y := 0.2*x + 25*x^2 / 2 - 200*x^3 / 3 + 675 * x^4 / 4 - 900*x^5 / 5 + 400 * x^6 / 6;
  end fd;
  
  parameter Real a = 0;
  parameter Real b = 0.8;
  Real I_a "value of integral using 3/8 rule";
  Real I_b "value of integral using 3/8 rule in conjection with 1/3 rule";
  Real Et_a "error in part (a)";
  Real et_a "relative error in part (a)";
  Real Et_b "error in part (b)";
  Real et_b "relative error in part (b)";
 equation
  I_a = (b-a) * (f(a) + 3*(f(0.2667) + f(0.5333)) + f(b))/8;
  I_b = (0.32-0) * (f(a) + 4 * f(0.16) + f(0.32)) / 6 + (0.8-0.32) * (f(0.32) + 3 * (f(0.48) + f(0.64)) + f(0.8))/8;
  Et_a = fd(b) - fd(a) - I_a;
  et_a = Et_a / (fd(b) - fd(a)) * 100;
  Et_b = fd(b) - fd(a) - I_b;
  et_b = Et_b / (fd(b) - fd(a)) * 100;

end Ex16_6;
