model Ex17_5 "applying gauss quadrature to falling parachutist problem"

  function f
    input Real x;
    input Real g;
    input Real m;
    input Real c;
    input Real a;
    input Real b;
    output Real y;
   algorithm
    y := (b-a) * g * m / c / 2 * (1 - exp( -c / m * ((b+a) + (b-a)*x)/2 ));
  end f;
  
  parameter Real m = 68.1;
  parameter Real c = 12.5;
  parameter Real g = 9.8;
  parameter Real a = 0 "lower limit of the integral";
  parameter Real b = 10 "upper limit of the integral";
  Real i2 "integral using two point estimate";
  Real i3 "integral using three point estimate";
  Real i4 "integral using four point estimate";
  Real i5 "integral using five point estimate";
  Real i6 "integral using six point estimate";
 equation
  i2 = 1 * f(-0.577350269, g,m,c,a,b) + 1 * f(0.577350269, g,m,c,a,b);
  i3 = 0.5555556 * f(-0.774596669, g,m,c,a,b) + 0.8888889 * f(0.0, g,m,c,a,b) + 0.5555556 * f(0.774596669, g,m,c,a,b);
  i4 =  0.3478548 * f(-0.861136312, g,m,c,a,b) +  0.6521452 * f(-0.339981044, g,m,c,a,b) + 0.6521452 * f(0.339981044, g,m,c,a,b) + 0.3478548 * f(0.861136312, g,m,c,a,b);
  i5 =  0.2369269 * f(-0.906179846, g,m,c,a,b) +   0.4786287 * f(-0.538469310, g,m,c,a,b) + 0.5688889 * f(0.0, g,m,c,a,b) + 0.4786287 * f(0.538469310, g,m,c,a,b) + 0.2369269 * f(0.906179846, g,m,c,a,b);
  i6 = 0.1713245 * f(-0.932469514, g,m,c,a,b) +   0.3607616 * f(-0.661209386, g,m,c,a,b) +  0.4679139 * f(-0.238619186, g,m,c,a,b) +  0.4679139 * f(0.238619186, g,m,c,a,b) + 0.3607616 * f(0.661209386, g,m,c,a,b) + 0.1713245 * f(0.932469514, g,m,c,a,b);
  
end Ex17_5;
