model Ex24_4 "Heated plate with irregular boundary"

  function gausselim
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   input Boolean y;
   output Real[n] x;
   protected
    Integer piv = 0;
    Real[n] temp_a = zeros(n);
    Real temp_b = 0;
    Real m = 0;
    Real max = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
   if y == true then
    max := abs(a[i,i]);
    piv := i;
    for j in i+1:n loop
      if abs(a[j,i]) > max then
        max := abs(a[j,i]);
        piv := j;
      end if;
    end for;
      for l in 1:n loop
        temp_a[l] := a[piv,l];
      end for;
      temp_b := b[piv];
      for t in 1:n loop
        a[piv,t] := a[i,t];
      end for;
      b[piv] := b[i];
      for p in 1:n loop
        a[i,p] := temp_a[p];
      end for;
      b[i] := temp_b;
     end if;
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end gausselim;  

  function mat
    input Real a;
    output Real[9, 9] m;
   algorithm
    m := zeros(9,9);
    for i in 1:9 loop
      m[i,i] := 4;
    end for;
    for i in 1:6 loop
      m[3+i, i] := -1;
    end for;
      m[1,4] := -0.845;
    for i in 2:6 loop
      m[i, i+3] := -1;
    end for;
    m[1,2] := -0.845;
    m[2,1] := -1;
    m[2,3] := -1;
    m[3,2] := -1;
    m[4,5] := -1;
    m[5,4] := -1;
    m[5,6] := -1;
    m[6,5] := -1;
    m[7,8] := -1;
    m[8,7] := -1;
    m[8,9] := -1;
    m[9,8] := -1;
  end mat;

  Real[9] T "matrix T = {T_11,T_21,T_31,T_12,T_22,T_32,T_13,T_23,T_33}";
  parameter Real[9] b = {173.2,75,125,75,0,50,175,100,150};
 equation
  T = gausselim(9, mat(1), b, false);

end Ex24_4;
