model Ex6_2 "polynomial deflation"
  function f
    input Real c;
    output Real y;
  algorithm
    y := c^3 - 13 * c - 12;
  end f;
  parameter Real x0_0 = 4.5;
  parameter Real x1_0 = 5.5;
  parameter Real x2_0 = 5;
  Real[4] x0;
  Real[4] x1;
  Real[4] x2;
  Real[4] xr;
  Real[4] h0;
  Real[4] s0;
  Real[4] h1;
  Real[4] s1;
  Real[4] ea "approximate error at each step";
  Real[4] a;
  Real[4] b;
  Real[4] c;
  Real[4] d "discriminant";
 equation
  h0[1] = x1_0 - x0_0; h1[1] = x2_0 - x1_0;
  s0[1] = (f(x1_0) - f(x0_0))/h0[1]; s1[1] = (f(x2_0) - f(x1_0))/h1[1];
  a[1] = (s1[1] - s0[1])/(h1[1] + h0[1]); b[1] = a[1] * h1[1] + s1[1];
  c[1] = f(x2_0);
  d[1] = sqrt((b[1])^2 - 4 * a[1] * c[1]);
  if b[1] > 0 then
    xr[1] = x2_0 - 2 * c[1] / (b[1] + d[1]);
  else
    xr[1] = x2_0 - 2 * c[1] / (b[1] - d[1]);
  end if;
  ea[1] = abs((xr[1] - x2_0)/xr[1]) * 100;
  x0[1] = x1_0; x1[1] = x2_0; x2[1] = xr[1];
  for i in 2:4 loop
    h0[i] = x1[i-1] - x0[i-1]; h1[i] = x2[i-1] - x1[i-1];
    s0[i] = (f(x1[i-1]) - f(x0[i-1]))/h0[i]; s1[i] = (f(x2[i-1]) - f(x1[i-1]))/h1[i];
    a[i] = (s1[i] - s0[i])/(h1[i] + h0[i]); b[i] = a[i] * h1[i] + s1[i];
    c[i] = f(x2[i-1]);
    d[i] = sqrt((b[i])^2 - 4 * a[i] * c[i]);
    if b[i] > 0 then
      xr[i] = x2[i-1] - 2 * c[i] / (b[i] + d[i]);
    else
      xr[i] = x2[i-1] - 2 * c[i] / (b[i] - d[i]);
    end if;
    ea[i] = abs((xr[i] - x2[i-1])/xr[i]) * 100;
    x0[i] = x1[i-1]; x1[i] = x2[i-1]; x2[i] = xr[i];
  end for;
end Ex6_2;
