model Ex8_2 "determinants"
  function d2
    input Real[2, 2] a;
    output Real y;
  algorithm
    y := a[1,1] * a[2, 2] - a[1, 2] * a[2, 1];
  end d2;
  parameter Real[2, 2] m1 = {{3, 2}, {-1, 2}} "matrix for figure 8.1";
  parameter Real[2, 2] m2a = {{-0.5, 1}, {-0.5, 1}} "matrix for figure 8.2a";
  parameter Real[2, 2] m2b = {{-0.5, 1}, {-1, 2}} "matrix for figure 8.2b";
  parameter Real[2, 2] m2c = {{-0.5, 1}, {-2.3/5, 1}} "matrix for figure 8.2c";
  Real d1 "determinant for 8.1";
  Real d2a "determinant for 8.2a";
  Real d2b "determinant for 8.2b";
  Real d2c "determinant for 8.2c";
 equation
  d1 = d2(m1);
  d2a = d2(m2a);
  d2b = d2(m2b);
  d2c = d2(m2c);
end Ex8_2;
