model Ex9_1 "LU Decomposition"
  function lu
   input Integer n;
   input Real[n, n] a0;
   output Real[n, n] l;
   output Real[n, n] u;
   protected
    Real sum = 0;
    Real m = 0;
   algorithm
   u := a0;
   l := identity(n);
  for i in 1:n-1 loop
    for j in i+1:n loop
      m := -1*u[j,i]/u[i,i];
      for k in i:n loop
        u[j,k] := u[j,k] + m * u[i,k];
      end for;
      l[j, i] := -m;
    end for;
  end for;
  end lu;
  
  parameter Integer n = 3 "size of the matrix";
  parameter Real[n, n] a = {{3, -0.1, -0.2}, {0.1, 7, -0.3}, {0.3, -0.2, 10}};
  Real[n, n] L;
  Real[n, n] U;
 equation
  (L, U) = lu(n, a);
end Ex9_1;
