model Ex9_2 "the substitution steps"
  function lu
   input Integer n;
   input Real[n, n] a0;
   output Real[n, n] l;
   output Real[n, n] u;
   protected
    Real sum = 0;
    Real m = 0;
   algorithm
   u := a0;
   l := identity(n);
  for i in 1:n-1 loop
    for j in i+1:n loop
      m := -1*u[j,i]/u[i,i];
      for k in i:n loop
        u[j,k] := u[j,k] + m * u[i,k];
      end for;
      l[j, i] := -m;
    end for;
  end for;
  end lu;
  
  function solution
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   output Real[n] x;
   protected
    Real m = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end solution;
  
  parameter Integer n = 3 "size of the matrix";
  parameter Real[n, n] a = {{3, -0.1, -0.2}, {0.1, 7, -0.3}, {0.3, -0.2, 10}};
  parameter Real[n] b = {7.85, -19.3, 71.4};
  Real[n] x "solution";
  Real[n, n] L;
  Real[n, n] U;
 equation
   x = solution(n, a, b);
  (L, U) = lu(n, a);
  
end Ex9_2;
