model Ex9_3 "matrix inversion"
  function lu
   input Integer n;
   input Real[n, n] a0;
   output Real[n, n] l;
   output Real[n, n] u;
   protected
    Real sum = 0;
    Real m = 0;
   algorithm
   u := a0;
   l := identity(n);
  for i in 1:n-1 loop
    for j in i+1:n loop
      m := -1*u[j,i]/u[i,i];
      for k in i:n loop
        u[j,k] := u[j,k] + m * u[i,k];
      end for;
      l[j, i] := -m;
    end for;
  end for;
  end lu;
  
  function gausselim
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   input Boolean y;
   output Real[n] x;
   protected
    Integer piv = 0;
    Real[n] temp_a = zeros(n);
    Real temp_b = 0;
    Real m = 0;
    Real max = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
   if y == true then
    max := abs(a[i,i]);
    piv := i;
    for j in i+1:n loop
      if abs(a[j,i]) > max then
        max := abs(a[j,i]);
        piv := j;
      end if;
    end for;
      for l in 1:n loop
        temp_a[l] := a[piv,l];
      end for;
      temp_b := b[piv];
      for t in 1:n loop
        a[piv,t] := a[i,t];
      end for;
      b[piv] := b[i];
      for p in 1:n loop
        a[i,p] := temp_a[p];
      end for;
      b[i] := temp_b;
     end if;
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end gausselim;
  
  function inv
    input Integer n;
    input Real[n, n] a;
    output Real[n, n] a_inv;
   protected
    Real[n, n] l;
    Real[n, n] u;
    Real[n] x_temp = zeros(n);
    Real[n] y_temp = zeros(n);
    Real[n] d_temp = zeros(n);
   algorithm
    (l, u) := lu(n, a);
    for i in 1:n loop
      d_temp[i] := 1;
      x_temp := gausselim(n, l, d_temp, true);
      y_temp := gausselim(n, u, x_temp, true);
      for j in 1:n loop
        a_inv[j, i] := y_temp[j];
      end for;
      d_temp := zeros(n);
      x_temp := zeros(n);
      y_temp := zeros(n);
    end for;
  end inv;
  
  parameter Integer n = 3;
  parameter Real[n, n] a =  {{3, -0.1, -0.2}, {0.1, 7, -0.3}, {0.3, -0.2, 10}};
  Real[n, n] a_inverse;
 equation
  a_inverse = inv(n, a);
end Ex9_3;
