﻿//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-1: Basic Concepts
//Example: 1.6 Page 21
//Title: Heat Transfer per unit length
//======================================================

model Ex1_6
//=============
// Parameter Section

parameter Real d(unit = "m") = 0.05 " Diameter of the pipe";
parameter Real e(unit = " ") = 0.8 " Emissivity of pipe ";
parameter Real Tr(unit = "C") = 30 " Room Temperature ";
parameter Real Ts(unit = "C") = 250 " Surface Temperature ";
parameter Real h(unit = "W/m^2 C") = 10 " Convective Heat Transfer Coefficient ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 " Stefan Boltzmann Constant";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
     
//=============
// Variable Section

Real Q(unit= "W/m") " Heat loss per unit length";
Real A(unit= "m^2") " Area of the pipe";

//=============
// Equation Section

equation

A=pi*d*1;

Q= (h*A*(Ts-Tr))+(e*sigma*A*(((Ts+273)^4)-((Tr+273)^4)));

end Ex1_6;
//======================================================-
//Error in answer in the book. Answer is 818.638 W/m. This is because 250℃ is taken as 723 K.
