//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.1 Page 403
//Title:  Surface temperature
//======================================================

model Ex10_1
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real I(unit="W/m^2")=1350 " Solar Irradiation";
parameter Real D(unit="m")=1.39e9 " Diameter of sun";
parameter Real L(unit="m")=1.5e11 " Distance ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real E(unit="W/m^2")" Emissive power";
Real T(unit="K")" Surface temperature";

//=============
// Equation Section

equation

E=(I*pi*L*L)/(pi*D*D/4);
T=(E/sigma)^0.25;

end Ex10_1;
//======================================================
